<?php
require_once 'includes/auth.php';

$msg = '';
$msgType = 'success';

// Wingo Helper Functions
// Keep the timezone matching what the game engine uses. Assuming Asia/Kolkata
define('WINGO_TIMEZONE', 'Asia/Kolkata');

function get_wingo_period_info() {
    date_default_timezone_set(WINGO_TIMEZONE); 
    
    // Use CONTINUOUS minute count (Epoch Minutes) to match game ID 29475880
    // Game ID 29475880 ~= 1768552800 (Jan 16 2026) / 60
    $now = time();
    $current_period = floor($now / 60);
    $next_period = $current_period + 1;
    
    // Seconds remaining in current minute
    $seconds_remaining = 60 - (int)date('s', $now);

    return ['current' => $current_period, 'next' => $next_period, 'remaining' => $seconds_remaining];
}

$wingoInfo = get_wingo_period_info();
$currentP = $wingoInfo['current'];
$nextP = $wingoInfo['next'];

// Handle POST Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $act = $_POST['action'] ?? '';

    try {
        if ($act === 'wingo_set') {
            $pid = $_POST['period_id'];
            $num = (int)$_POST['number'];
            $stmt = $db->prepare("INSERT INTO wingo_fixed_results (period_id, number) VALUES (?, ?) ON DUPLICATE KEY UPDATE number = ?");
            $stmt->execute([$pid, $num, $num]);
            $msg = "Fixed Result Set: Period $pid will land on " . h($num); 
            $msgType = 'success';
        }
        
        if ($act === 'wingo_delete') {
            $pid = $_POST['period_id'];
            $stmt = $db->prepare("DELETE FROM wingo_fixed_results WHERE period_id = ?");
            $stmt->execute([$pid]);
            $msg = "Removed fixed result for Period $pid"; 
            $msgType = 'success';
        }
    } catch (Exception $e) {
        $msg = "Database Error: " . $e->getMessage();
        $msgType = 'error';
    }
}

// Fetch Fixed Results (Upcoming and Recent)
$fixed = $db->query("SELECT * FROM wingo_fixed_results WHERE period_id >= " . ($currentP-1) . " ORDER BY period_id ASC")->fetchAll();

// Fetch Live Bets for the Current Period
$stmtBets = $db->prepare("SELECT * FROM wingo_bets WHERE period_id = ? ORDER BY id DESC");
$stmtBets->execute([$currentP]);
$currentBets = $stmtBets->fetchAll();

$totalBetAmount = 0;
foreach ($currentBets as $b) { 
    $totalBetAmount += $b['amount']; 
}

require_once 'includes/header.php';
?>

<div class="mb-8 flex flex-col md:flex-row md:items-end justify-between gap-4">
    <div>
        <h1 class="text-2xl font-bold text-white tracking-tight">Wingo Controller</h1>
        <p class="text-sm text-slate-400 mt-1">Monitor live 1-Minute Wingo betting and set upcoming fixed results.</p>
    </div>
    <div class="flex items-center gap-4 bg-slate-800/80 px-4 py-3 rounded-xl border border-slate-700/50">
        <div>
            <p class="text-[10px] font-bold text-slate-500 uppercase tracking-widest leading-none mb-1">Current Period</p>
            <p class="text-lg font-black text-indigo-400 leading-none"><?= $currentP ?></p>
        </div>
        <div class="w-px h-8 bg-slate-700/50"></div>
        <div>
            <p class="text-[10px] font-bold text-slate-500 uppercase tracking-widest leading-none mb-1">Time Left</p>
            <p class="text-lg font-black text-amber-400 leading-none flex items-center gap-1">
                <i data-feather="clock" class="w-4 h-4"></i> <span id="wingo-timer"><?= $wingoInfo['remaining'] ?></span>s
            </p>
        </div>
    </div>
</div>

<?php if($msg): ?>
    <div class="mb-6 p-4 rounded-xl flex items-start gap-3 border <?= $msgType === 'success' ? 'bg-green-500/10 border-green-500/20 text-green-400' : 'bg-red-500/10 border-red-500/20 text-red-400' ?>">
        <i data-feather="<?= $msgType === 'success' ? 'check-circle' : 'alert-circle' ?>" class="w-5 h-5 shrink-0 mt-0.5"></i>
        <p class="text-sm font-medium"><?= h($msg) ?></p>
    </div>
<?php endif; ?>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
    
    <!-- Fix Results Control -->
    <div class="lg:col-span-1 border border-slate-700/50 bg-slate-800/50 backdrop-blur-sm rounded-2xl shadow-lg shadow-slate-900/50 p-6 flex flex-col relative overflow-hidden">
        <div class="absolute -right-6 -top-6 w-32 h-32 bg-indigo-500/10 rounded-full blur-2xl pointer-events-none"></div>
        <h2 class="text-lg font-bold text-white flex items-center gap-2 mb-6">
            <i data-feather="crosshair" class="w-5 h-5 text-indigo-400"></i> Rig Next Result
        </h2>

        <form method="POST" class="flex flex-col flex-1">
            <input type="hidden" name="action" value="wingo_set">
            
            <label class="text-xs font-bold text-slate-400 uppercase tracking-widest pl-1 mb-2">Target Period ID</label>
            <input type="number" name="period_id" value="<?= $nextP ?>" class="w-full bg-slate-900 border border-slate-700 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-indigo-500 transition-colors mb-6 font-mono text-lg" required>
            
            <label class="text-xs font-bold text-slate-400 uppercase tracking-widest pl-1 mb-2">Force Result Number</label>
            <div class="grid grid-cols-5 gap-2 mb-8">
                <?php for($i=0; $i<=9; $i++): 
                    $btnColor = ($i==0||$i==5) ? 'bg-purple-500/10 border-purple-500/30 text-purple-400 peer-checked:bg-purple-600 peer-checked:text-white' : (($i%2==1) ? 'bg-green-500/10 border-green-500/30 text-green-400 peer-checked:bg-green-600 peer-checked:text-white' : 'bg-red-500/10 border-red-500/30 text-red-400 peer-checked:bg-red-600 peer-checked:text-white');
                ?>
                    <label class="relative cursor-pointer group">
                        <input type="radio" name="number" value="<?= $i ?>" class="peer sr-only" required <?= ($i==0) ? 'checked' : '' ?>>
                        <div class="border rounded-xl py-3 text-center font-black text-xl transition-all peer-checked:shadow-lg peer-checked:scale-105 <?= $btnColor ?>">
                            <?= $i ?>
                        </div>
                    </label>
                <?php endfor; ?>
            </div>
            
            <div class="mt-auto">
                <button type="submit" class="w-full bg-indigo-600 hover:bg-indigo-500 text-white py-3.5 rounded-xl font-bold tracking-wide transition-all shadow-lg shadow-indigo-600/20 border border-indigo-500/50 flex items-center justify-center gap-2">
                    <i data-feather="zap" class="w-4 h-4"></i> Lock in Result
                </button>
            </div>
        </form>
    </div>

    <!-- Active Rigged Results Queue -->
    <div class="lg:col-span-2 border border-slate-700/50 bg-slate-800/50 backdrop-blur-sm rounded-2xl shadow-lg shadow-slate-900/50 overflow-hidden flex flex-col">
        <div class="p-6 border-b border-slate-700/50 flex items-center justify-between bg-slate-800/80">
            <h2 class="text-lg font-bold text-white flex items-center gap-2">
                <i data-feather="settings" class="w-5 h-5 text-slate-400"></i> Upcoming Fixed Draw Queue
            </h2>
        </div>
        <div class="p-0 overflow-y-auto max-h-[400px]">
            <?php if(empty($fixed)): ?>
                <div class="p-12 text-center flex flex-col items-center justify-center h-full text-slate-500 font-medium">
                    <div class="w-16 h-16 bg-slate-800 rounded-full flex items-center justify-center mb-4 border border-slate-700">
                        <i data-feather="wind" class="w-8 h-8 text-slate-600"></i>
                    </div>
                    No future results are rigged. Game running on pure RNG.
                </div>
            <?php else: ?>
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-slate-900/50 border-b border-slate-700/50">
                            <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest pl-6">Period target</th>
                            <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest text-center">Result Number</th>
                            <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest text-right pr-6">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-800/50">
                        <?php foreach($fixed as $f): 
                            $n = $f['number'];
                            $colorClass = ($n==0||$n==5) ? 'bg-purple-500 text-white' : (($n%2==1) ? 'bg-green-500 text-white' : 'bg-red-500 text-white');
                        ?>
                        <tr class="hover:bg-slate-800/40 transition-colors">
                            <td class="p-4 pl-6">
                                <span class="font-mono font-bold text-slate-200 text-sm flex items-center gap-2">
                                    <?= h($f['period_id']) ?>
                                    <?php if($f['period_id'] == $currentP): ?>
                                        <span class="bg-amber-500/20 text-amber-400 border border-amber-500/30 text-[9px] px-1.5 py-0.5 rounded uppercase tracking-wider font-bold">Active Now</span>
                                    <?php elseif($f['period_id'] == $nextP): ?>
                                        <span class="bg-blue-500/20 text-blue-400 border border-blue-500/30 text-[9px] px-1.5 py-0.5 rounded uppercase tracking-wider font-bold">Next</span>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td class="p-4 text-center">
                                <span class="inline-flex w-8 h-8 rounded-full items-center justify-center font-black shadow <?= $colorClass ?> border border-white/10">
                                    <?= $n ?>
                                </span>
                            </td>
                            <td class="p-4 pr-6 text-right">
                                <form method="POST">
                                    <input type="hidden" name="action" value="wingo_delete">
                                    <input type="hidden" name="period_id" value="<?= $f['period_id'] ?>">
                                    <button class="bg-slate-700 hover:bg-red-500/20 text-slate-300 hover:text-red-400 border border-slate-600 hover:border-red-500/30 px-3 py-1.5 rounded-lg text-xs font-bold transition-all flex items-center gap-1.5 ml-auto">
                                        <i data-feather="trash-2" class="w-3 h-3"></i> Clear
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Live Betting Volume -->
<div class="border border-slate-700/50 bg-slate-800/50 backdrop-blur-sm rounded-2xl shadow-lg shadow-slate-900/50 overflow-hidden relative">
    <div class="absolute right-0 top-0 w-64 h-64 bg-green-500/5 rounded-full blur-3xl pointer-events-none"></div>

    <div class="p-6 border-b border-slate-700/50 flex flex-col md:flex-row md:items-center justify-between gap-4 bg-slate-800/80">
        <div>
            <h2 class="text-lg font-bold text-white flex items-center gap-2">
                <i data-feather="activity" class="w-5 h-5 text-emerald-400"></i> Live Betting Stream
            </h2>
            <p class="text-xs text-slate-400 mt-1 uppercase tracking-widest font-bold">Currently settling for Period <span class="text-indigo-400 font-black">#<?= $currentP ?></span></p>
        </div>

        <div class="flex items-center gap-6 bg-slate-900 border border-slate-700/50 rounded-xl px-4 py-2">
            <div class="text-center">
                <p class="text-[9px] font-bold text-slate-500 uppercase tracking-widest mb-0.5">Tickets</p>
                <p class="text-lg font-black text-white leading-none"><?= count($currentBets) ?></p>
            </div>
            <div class="w-px h-8 bg-slate-700/50"></div>
            <div class="text-center">
                <p class="text-[9px] font-bold text-slate-500 uppercase tracking-widest mb-0.5">Total Volume</p>
                <p class="text-lg font-black text-emerald-400 leading-none">₹<?= money($totalBetAmount) ?></p>
            </div>
            <a href="?_" class="bg-slate-700 hover:bg-slate-600 text-white w-8 h-8 rounded-lg flex items-center justify-center transition-colors ml-2" title="Refresh Live Data">
                <i data-feather="refresh-cw" class="w-4 h-4"></i>
            </a>
        </div>
    </div>

    <div class="overflow-x-auto max-h-[500px]">
        <table class="w-full text-left border-collapse relative">
            <thead class="sticky top-0 bg-slate-900 z-10 border-b border-slate-700/50 shadow-sm">
                <tr>
                    <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest pl-6">Time placed</th>
                    <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest">Player</th>
                    <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest text-center">Bet Selection</th>
                    <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest text-right">Stake Amount</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-800/50 bg-slate-800/20">
                <?php if(empty($currentBets)): ?>
                    <tr><td colspan="4" class="p-16 text-center text-slate-500 font-medium">Bids haven't opened yet or no liquidity for this round.</td></tr>
                <?php else: ?>
                    <?php foreach($currentBets as $bet): 
                        $val = $bet['bet_value'];
                        $badgeClass = 'bg-slate-700 text-white';
                        if ($val === 'green') $badgeClass = 'bg-green-500/10 text-green-400 border border-green-500/20';
                        elseif ($val === 'red') $badgeClass = 'bg-red-500/10 text-red-400 border border-red-500/20';
                        elseif ($val === 'violet') $badgeClass = 'bg-purple-500/10 text-purple-400 border border-purple-500/20';
                        elseif ($val === 'big') $badgeClass = 'bg-yellow-500/10 text-yellow-500 border border-yellow-500/20';
                        elseif ($val === 'small') $badgeClass = 'bg-blue-500/10 text-blue-400 border border-blue-500/20';
                        elseif (is_numeric($val)) {
                            // Number buttons
                            $badgeClass = 'bg-slate-800 text-slate-200 border border-slate-600';
                            if ($val == 0 || $val == 5) $badgeClass = 'bg-purple-500/20 text-purple-300 border border-purple-500/30';
                            elseif ($val % 2 == 1) $badgeClass = 'bg-green-500/20 text-green-300 border border-green-500/30';
                            else $badgeClass = 'bg-red-500/20 text-red-300 border border-red-500/30';
                        }
                    ?>
                    <tr class="hover:bg-slate-700/40 transition-colors">
                        <td class="p-4 pl-6 text-slate-400 font-mono text-xs">
                            <?= date('H:i:s', strtotime($bet['created_at'])) ?>
                        </td>
                        <td class="p-4 font-bold text-slate-200">
                            <?= h($bet['user_id']) ?>
                        </td>
                        <td class="p-4 text-center">
                            <span class="px-3 py-1 rounded shadow-sm text-xs font-bold uppercase tracking-wide <?= $badgeClass ?>">
                                <?= h($val) ?>
                            </span>
                        </td>
                        <td class="p-4 text-right">
                            <span class="font-black text-white tracking-tight">₹<?= money($bet['amount']) ?></span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
// Simple countdown timer logic just for UI feedback
document.addEventListener("DOMContentLoaded", function() {
    let timeLeft = parseInt(document.getElementById('wingo-timer').innerText);
    setInterval(function() {
        timeLeft--;
        if(timeLeft < 0) {
            // Auto reload at exactly 0 to fetch new period and clear bets
            window.location.reload();
        } else {
            document.getElementById('wingo-timer').innerText = timeLeft;
        }
    }, 1000);
});
</script>

<?php require_once 'includes/footer.php'; ?>
