<?php
require_once 'includes/auth.php';

$msg = '';
$msgType = 'success';

// Handle POST actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $act = $_POST['action'] ?? '';
    
    if ($act === 'user_update') {
        $uid = $_POST['user_id'];
        $mode = $_POST['mode'];

        try {
            $db->beginTransaction();

            if ($mode === 'credit') {
                $amt = (float)$_POST['amount'];
                if ($amt <= 0) throw new Exception("Amount must be greater than 0");
                $db->prepare("UPDATE users SET balance = balance + ? WHERE user_id = ?")->execute([$amt, $uid]);
                $db->prepare("INSERT INTO transactions (user_id, type, amount, status, transaction_id) VALUES (?, 'admin_deposit', ?, 'completed', ?)")->execute([$uid, $amt, 'ADM'.time()]);
                $msg = "Credited ₹" . money($amt) . " to " . h($uid);
            } 
            elseif ($mode === 'debit') {
                $amt = (float)$_POST['amount'];
                if ($amt <= 0) throw new Exception("Amount must be greater than 0");
                $db->prepare("UPDATE users SET balance = GREATEST(0, balance - ?) WHERE user_id = ?")->execute([$amt, $uid]);
                $msg = "Debited ₹" . money($amt) . " from " . h($uid);
            } 
            elseif ($mode === 'add_turnover') {
                $amt = (float)$_POST['amount'];
                if ($amt <= 0) throw new Exception("Turnover amount must be greater than 0");
                $db->prepare("UPDATE users SET turnover_required = turnover_required + ? WHERE user_id = ?")->execute([$amt, $uid]);
                $msg = "Added ₹" . money($amt) . " to Turnover Requirement";
            } 
            elseif ($mode === 'ban') {
                $reason = trim($_POST['ban_reason'] ?? 'Account banned by admin');
                $db->prepare("UPDATE users SET is_banned = 1, ban_reason = ? WHERE user_id = ?")->execute([$reason, $uid]);
                $msg = "Banned User " . h($uid) . ". Reason: " . h($reason);
            } 
            elseif ($mode === 'unban') {
                $db->prepare("UPDATE users SET is_banned = 0, ban_reason = NULL WHERE user_id = ?")->execute([$uid]);
                $msg = "Unbanned User " . h($uid);
            } 
            elseif ($mode === 'tutor_on') {
                $db->prepare("UPDATE users SET is_tutor = 1 WHERE user_id = ?")->execute([$uid]);
                $msg = h($uid) . " is now a Tutor";
            } 
            elseif ($mode === 'tutor_off') {
                $db->prepare("UPDATE users SET is_tutor = 0 WHERE user_id = ?")->execute([$uid]);
                $msg = "Removed Tutor status from " . h($uid);
            }
            elseif ($mode === 'set_commission') {
                $l1 = (float)($_POST['comm_lvl_1'] ?? 0);
                $l2 = (float)($_POST['comm_lvl_2'] ?? 0);
                $l3 = (float)($_POST['comm_lvl_3'] ?? 0);
                $l4 = (float)($_POST['comm_lvl_4'] ?? 0);
                $l5 = (float)($_POST['comm_lvl_5'] ?? 0);
                $l6 = (float)($_POST['comm_lvl_6'] ?? 0);
                
                $arr = [1 => $l1, 2 => $l2, 3 => $l3, 4 => $l4, 5 => $l5, 6 => $l6];
                $json = json_encode($arr);
                
                $stmt = $db->prepare("INSERT INTO settings (k, v) VALUES (?, ?) ON DUPLICATE KEY UPDATE v = ?");
                $stmt->execute(['rates_'.$uid, $json, $json]);
                $db->prepare("UPDATE users SET commission_rate = ? WHERE user_id = ?")->execute([$l1, $uid]);
                $msg = "Multi-level commission rates updated for " . h($uid);
            }
            $db->commit();
        } catch (Exception $e) {
            if ($db->inTransaction()) $db->rollBack();
            $msg = $e->getMessage();
            $msgType = 'error';
        }
    }
}

// Fetch Search Query
$q = $_GET['q'] ?? '';
$sql = "SELECT * FROM users";
$params = [];
if ($q) {
    $sql .= " WHERE user_id LIKE ? OR phone LIKE ?";
    $params = ["%$q%", "%$q%"];
}
$sql .= " ORDER BY id DESC LIMIT 100";
$stmt = $db->prepare($sql);
$stmt->execute($params);
$users = $stmt->fetchAll();

// Fetch Settings Rates
$allRates = [];
$rateStmt = $db->query("SELECT k, v FROM settings WHERE k LIKE 'rates_%'");
foreach($rateStmt as $row) {
    if (strpos($row['k'], 'rates_') === 0) {
        $u_id = substr($row['k'], 6);
        $allRates[$u_id] = json_decode($row['v'], true);
    }
}

require_once 'includes/header.php';
?>

<div class="mb-8 flex flex-col md:flex-row md:items-end justify-between gap-4">
    <div>
        <h1 class="text-2xl font-bold text-white tracking-tight">Player Management</h1>
        <p class="text-sm text-slate-400 mt-1">Search, update balances, manage bans, and configure agents.</p>
    </div>
    
    <form method="GET" class="flex items-center gap-2">
        <div class="relative w-full md:w-64">
            <i data-feather="search" class="w-4 h-4 absolute left-3 top-1/2 -translate-y-1/2 text-slate-500"></i>
            <input type="text" name="q" value="<?= h($q) ?>" placeholder="Search User ID or Phone" class="w-full bg-slate-800/80 border border-slate-700/50 rounded-xl pl-9 pr-4 py-2.5 text-sm text-white placeholder:text-slate-500 focus:outline-none focus:ring-2 focus:ring-blue-500/50">
        </div>
        <button type="submit" class="bg-blue-600 hover:bg-blue-500 text-white px-4 py-2.5 rounded-xl font-semibold text-sm transition-colors border border-blue-500/50 shadow-lg shadow-blue-500/20">Search</button>
        <?php if($q): ?>
            <a href="users.php" class="bg-slate-800 hover:bg-slate-700 text-slate-300 px-4 py-2.5 rounded-xl font-semibold text-sm transition-colors border border-slate-700">Clear</a>
        <?php endif; ?>
    </form>
</div>

<?php if($msg): ?>
    <div class="mb-6 p-4 rounded-xl flex items-start gap-3 border <?= $msgType === 'success' ? 'bg-green-500/10 border-green-500/20 text-green-400' : 'bg-red-500/10 border-red-500/20 text-red-400' ?>">
        <i data-feather="<?= $msgType === 'success' ? 'check-circle' : 'alert-circle' ?>" class="w-5 h-5 shrink-0 mt-0.5"></i>
        <p class="text-sm font-medium"><?= h($msg) ?></p>
    </div>
<?php endif; ?>

<div class="bg-slate-800/50 backdrop-blur-sm border border-slate-700/50 rounded-2xl shadow-lg shadow-slate-900/50 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full text-left border-collapse">
            <thead>
                <tr class="bg-slate-900/50 border-b border-slate-700/50">
                    <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest whitespace-nowrap">Player Info</th>
                    <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest whitespace-nowrap">Financials</th>
                    <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest min-w-[300px]">Quick Actions</th>
                    <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest min-w-[280px]">Status & Bans</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-800/50">
                <?php if(empty($users)): ?>
                    <tr><td colspan="4" class="p-8 text-center text-slate-500 font-medium">No users found matching your search.</td></tr>
                <?php endif; ?>

                <?php foreach ($users as $u): 
                    $uRates = $allRates[$u['user_id']] ?? [];
                    $u_l1 = isset($uRates[1]) ? $uRates[1] : $u['commission_rate'];
                    $u_l2 = $uRates[2] ?? 0;
                    $u_l3 = $uRates[3] ?? 0;
                    $u_l4 = $uRates[4] ?? 0;
                    $u_l5 = $uRates[5] ?? 0;
                    $u_l6 = $uRates[6] ?? 0;
                ?>
                <tr class="hover:bg-slate-800/40 transition-colors group">
                    <td class="p-4 align-top">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-full bg-slate-700 flex flex-col items-center justify-center shrink-0 border <?= $u['is_tutor'] ? 'border-purple-500/50 text-purple-400' : 'border-slate-600 text-slate-400' ?>">
                                <i data-feather="<?= $u['is_tutor'] ? 'star' : 'user' ?>" class="w-4 h-4"></i>
                            </div>
                            <div>
                                <p class="font-bold text-slate-200 text-sm flex items-center gap-2">
                                    <?= h($u['user_id']) ?>
                                    <?php if($u['is_banned']): ?>
                                        <span class="bg-red-500/10 text-red-500 border border-red-500/20 text-[9px] px-1.5 py-0.5 rounded uppercase tracking-wider font-bold">Banned</span>
                                    <?php elseif($u['is_tutor']): ?>
                                        <span class="bg-purple-500/10 text-purple-400 border border-purple-500/20 text-[9px] px-1.5 py-0.5 rounded uppercase tracking-wider font-bold">Tutor</span>
                                    <?php endif; ?>
                                </p>
                                <p class="text-xs text-slate-500 font-medium tracking-wide mt-0.5"><?= h($u['phone']) ?></p>
                                <p class="text-[10px] text-slate-500 mt-1">Joined: <?= date('M d, Y', strtotime($u['created_at'])) ?></p>
                            </div>
                        </div>
                    </td>
                    <td class="p-4 align-top">
                        <div class="text-lg font-black tracking-tight text-green-400">₹<?= money($u['balance']) ?></div>
                        <div class="text-xs text-slate-500 mt-1">Req. TO: <b class="text-slate-300">₹<?= money($u['turnover_required']) ?></b></div>
                        <div class="text-xs text-slate-500 mt-0.5">Base Comm: <b class="text-blue-400"><?= $u_l1 ?>%</b></div>
                    </td>
                    <td class="p-4 align-top">
                        <form method="POST" class="space-y-3">
                            <input type="hidden" name="action" value="user_update">
                            <input type="hidden" name="user_id" value="<?= $u['user_id'] ?>">
                            
                            <!-- Balance Edit -->
                            <div class="flex items-center gap-2">
                                <div class="relative flex-1">
                                    <span class="absolute left-3 top-1/2 -translate-y-1/2 text-slate-500 text-xs font-bold">₹</span>
                                    <input type="number" name="amount" placeholder="Amount" step="0.1" class="w-full bg-slate-900 border border-slate-700 rounded-lg pl-7 pr-3 py-1.5 text-xs text-white placeholder:text-slate-600 focus:outline-none focus:border-blue-500">
                                </div>
                                <button type="submit" name="mode" value="credit" class="bg-green-600 hover:bg-green-500 text-white px-2.5 py-1.5 rounded-lg text-xs font-bold transition-colors" title="Add Balance">+</button>
                                <button type="submit" name="mode" value="debit" class="bg-red-600 hover:bg-red-500 text-white px-2.5 py-1.5 rounded-lg text-xs font-bold transition-colors" title="Deduct Balance">-</button>
                                <button type="submit" name="mode" value="add_turnover" class="bg-amber-600 hover:bg-amber-500 text-white px-2.5 py-1.5 rounded-lg text-xs font-bold transition-colors" title="Add Wager Requirement">Add TO</button>
                            </div>

                            <!-- Comm Matrix -->
                            <div class="bg-slate-900 border border-slate-700/50 rounded-lg p-2 relative">
                                <span class="absolute -top-2 left-2 bg-slate-800 px-1 text-[9px] font-bold text-slate-400 uppercase tracking-wider">Lvl 1-6 Rates</span>
                                <div class="grid grid-cols-6 gap-1 mb-2 mt-1">
                                    <input type="number" name="comm_lvl_1" value="<?= $u_l1 ?>" step="0.01" class="w-full bg-slate-950 border border-slate-800 rounded px-1 py-1 text-[10px] text-center text-white focus:border-blue-500 outline-none" title="Level 1 %">
                                    <input type="number" name="comm_lvl_2" value="<?= $u_l2 ?>" step="0.01" class="w-full bg-slate-950 border border-slate-800 rounded px-1 py-1 text-[10px] text-center text-white focus:border-blue-500 outline-none" title="Level 2 %">
                                    <input type="number" name="comm_lvl_3" value="<?= $u_l3 ?>" step="0.01" class="w-full bg-slate-950 border border-slate-800 rounded px-1 py-1 text-[10px] text-center text-white focus:border-blue-500 outline-none" title="Level 3 %">
                                    <input type="number" name="comm_lvl_4" value="<?= $u_l4 ?>" step="0.01" class="w-full bg-slate-950 border border-slate-800 rounded px-1 py-1 text-[10px] text-center text-white focus:border-blue-500 outline-none" title="Level 4 %">
                                    <input type="number" name="comm_lvl_5" value="<?= $u_l5 ?>" step="0.01" class="w-full bg-slate-950 border border-slate-800 rounded px-1 py-1 text-[10px] text-center text-white focus:border-blue-500 outline-none" title="Level 5 %">
                                    <input type="number" name="comm_lvl_6" value="<?= $u_l6 ?>" step="0.01" class="w-full bg-slate-950 border border-slate-800 rounded px-1 py-1 text-[10px] text-center text-white focus:border-blue-500 outline-none" title="Level 6 %">
                                </div>
                                <button type="submit" name="mode" value="set_commission" class="w-full bg-slate-700 hover:bg-slate-600 text-slate-200 py-1.5 rounded text-[10px] font-bold uppercase tracking-wider transition-colors border border-slate-600/50">Save Rates</button>
                            </div>
                        </form>
                    </td>
                    <td class="p-4 align-top">
                        <form method="POST" class="space-y-3">
                            <input type="hidden" name="action" value="user_update">
                            <input type="hidden" name="user_id" value="<?= $u['user_id'] ?>">
                            
                            <!-- Bans -->
                            <div class="bg-slate-900 border border-slate-700/50 rounded-lg p-2 relative mt-2">
                                <span class="absolute -top-2 left-2 bg-slate-800 px-1 text-[9px] font-bold text-slate-400 uppercase tracking-wider">Account Access</span>
                                
                                <?php if ($u['is_banned']): ?>
                                    <div class="text-xs text-red-400 font-medium mb-2 bg-red-500/10 p-2 rounded border border-red-500/20 italic mt-1">
                                        "<?= h($u['ban_reason'] ?: 'No reason provided') ?>"
                                    </div>
                                    <button type="submit" name="mode" value="unban" class="w-full bg-emerald-600/20 hover:bg-emerald-600/30 text-emerald-400 border border-emerald-500/30 py-1.5 rounded textxs font-bold transition-colors">Lift Ban</button>
                                <?php else: ?>
                                    <input type="text" name="ban_reason" placeholder="Reason for ban..." class="w-full bg-slate-950 border border-slate-800 rounded px-2 py-1.5 text-xs text-white focus:border-red-500 outline-none mb-1.5 mt-1" required>
                                    <button type="submit" name="mode" value="ban" class="w-full bg-red-600/20 hover:bg-red-600/30 text-red-500 border border-red-500/30 py-1.5 rounded text-xs font-bold transition-colors">Ban Account</button>
                                <?php endif; ?>
                            </div>

                            <!-- Tutor -->
                            <button type="submit" name="mode" value="<?= $u['is_tutor'] ? 'tutor_off' : 'tutor_on' ?>" class="w-full py-1.5 rounded-lg border text-xs font-bold transition-colors flex items-center justify-center gap-2 <?= $u['is_tutor'] ? 'bg-slate-800 text-slate-400 border-slate-700 hover:text-white' : 'bg-purple-600/20 text-purple-400 border-purple-500/30 hover:bg-purple-600/30 hover:text-purple-300' ?>">
                                <i data-feather="<?= $u['is_tutor'] ? 'x' : 'star' ?>" class="w-3 h-3"></i> 
                                <?= $u['is_tutor'] ? 'Remove Tutor Status' : 'Make Tutor' ?>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
