<?php
require_once 'includes/auth.php';

$msg = '';
$msgType = 'success';

// Handle Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $act = $_POST['action'] ?? '';

    if ($act === 'support_ticket_resolve') {
        $id = (int)($_POST['ticket_id'] ?? 0);
        try {
            $stmt = $db->prepare("UPDATE support_tickets SET status = 'closed', resolved_at = NOW() WHERE id = ?");
            $stmt->execute([$id]);
            $msg = "Ticket #$id marked as closed.";
            $msgType = 'success';
        } catch (Exception $e) {
            $msg = "Error resolving ticket: " . $e->getMessage();
            $msgType = 'error';
        }
    }
}

$filter = $_GET['filter'] ?? 'open';
$allowed = ['open', 'closed', 'all'];
if (!in_array($filter, $allowed)) $filter = 'open';

$sql = "SELECT t.*, u.phone FROM support_tickets t LEFT JOIN users u ON t.user_id = u.user_id ";
if ($filter === 'open') $sql .= "WHERE t.status = 'open' ";
elseif ($filter === 'closed') $sql .= "WHERE t.status = 'closed' ";
$sql .= "ORDER BY t.id DESC LIMIT 100";

$tickets = $db->query($sql)->fetchAll(PDO::FETCH_ASSOC);

require_once 'includes/header.php';
?>

<div class="mb-8 flex flex-col md:flex-row md:items-end justify-between gap-4">
    <div>
        <h1 class="text-2xl font-bold text-white tracking-tight flex items-center gap-2">
            <i data-feather="life-buoy" class="w-6 h-6 text-blue-500"></i> Help & Support Desk
        </h1>
        <p class="text-sm text-slate-400 mt-1">Review and resolve player support queries.</p>
    </div>
    
    <div class="flex items-center gap-1.5 bg-slate-800/80 p-1 rounded-xl border border-slate-700/50 flex-wrap">
        <?php foreach(['open'=>'⏳ Awaiting Reply', 'closed'=>'✅ Closed', 'all'=>'All Tickets'] as $s => $label): ?>
            <a href="?filter=<?= $s ?>" class="px-4 py-2 rounded-lg text-sm font-bold transition-all <?= $filter === $s ? 'bg-blue-600 text-white shadow-lg shadow-blue-600/20' : 'text-slate-400 hover:text-white hover:bg-slate-700' ?>">
                <?= $label ?>
            </a>
        <?php endforeach; ?>
    </div>
</div>

<?php if($msg): ?>
    <div class="mb-6 p-4 rounded-xl flex items-start gap-3 border <?= $msgType === 'success' ? 'bg-green-500/10 border-green-500/20 text-green-400' : 'bg-red-500/10 border-red-500/20 text-red-400' ?>">
        <i data-feather="<?= $msgType === 'success' ? 'check-circle' : 'alert-circle' ?>" class="w-5 h-5 shrink-0 mt-0.5"></i>
        <p class="text-sm font-medium"><?= h($msg) ?></p>
    </div>
<?php endif; ?>

<div class="bg-slate-800/50 backdrop-blur-sm border border-slate-700/50 rounded-2xl shadow-lg shadow-slate-900/50 overflow-hidden">
    <?php if(empty($tickets)): ?>
        <div class="p-16 text-center text-slate-500 font-medium flex flex-col items-center">
            <div class="w-16 h-16 bg-slate-800 rounded-full flex items-center justify-center mb-4 border border-slate-700">
                <i data-feather="check-circle" class="w-8 h-8 text-green-500"></i>
            </div>
            Inbox zero! All caught up on <?= h($filter) ?> tickets.
        </div>
    <?php else: ?>
        <div class="overflow-x-auto min-h-[500px]">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-slate-900/50 border-b border-slate-700/50">
                        <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest pl-6">Query Issue</th>
                        <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest">Player</th>
                        <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest min-w-[300px]">Detailed Description</th>
                        <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest text-center">Status</th>
                        <th class="p-4 text-xs font-bold text-slate-400 uppercase tracking-widest text-right pr-6">Resolution</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-800/50 text-sm">
                    <?php foreach($tickets as $t): 
                        $isResolved = $t['status'] === 'closed';
                    ?>
                        <tr class="hover:bg-slate-800/40 transition-colors group <?= $isResolved ? 'opacity-70' : '' ?>">
                            <td class="p-4 pl-6 align-top">
                                <div class="font-bold text-white mb-1 uppercase tracking-wider text-xs flex items-center gap-1.5">
                                    <i data-feather="<?= $t['issue_type'] == 'deposit' ? 'credit-card' : ($t['issue_type'] == 'withdrawal' ? 'dollar-sign' : 'help-circle') ?>" class="w-3.5 h-3.5 text-blue-400"></i>
                                    <?= h($t['issue_type']) ?>
                                </div>
                                <div class="text-[10px] text-slate-500 font-mono">TKT-<?= $t['id'] ?></div>
                            </td>
                            <td class="p-4 align-top">
                                <div class="font-bold text-indigo-400"><?= h($t['user_id']) ?></div>
                                <div class="text-xs text-slate-500 mt-1"><?= h($t['phone'] ?? 'N/A') ?></div>
                            </td>
                            <td class="p-4 align-top">
                                <div class="text-slate-300 leading-relaxed whitespace-pre-wrap font-medium">
                                    <?= h($t['description']) ?>
                                </div>
                                <div class="text-[10px] text-slate-500 font-medium mt-3 flex items-center gap-1">
                                    <i data-feather="clock" class="w-3 h-3"></i> Opened: <?= date('M d, Y H:i', strtotime($t['created_at'])) ?>
                                </div>
                            </td>
                            <td class="p-4 align-top text-center">
                                <?php if ($isResolved): ?>
                                    <span class="inline-flex items-center gap-1.5 bg-green-500/10 text-green-400 border border-green-500/20 px-2.5 py-1 rounded-lg text-[10px] font-bold uppercase tracking-wider">
                                        <i data-feather="check" class="w-3 h-3"></i> Resolved
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex items-center gap-1.5 bg-yellow-500/10 text-yellow-500 border border-yellow-500/20 px-2.5 py-1 rounded-lg text-[10px] font-bold uppercase tracking-wider">
                                        <div class="w-1.5 h-1.5 rounded-full bg-yellow-500 animate-pulse mt-0.5"></div> Pending Response
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="p-4 pr-6 align-top text-right">
                                <?php if (!$isResolved): ?>
                                    <form method="POST" class="flex justify-end" onsubmit="return confirm('Close ticket TKT-<?= $t['id'] ?> as resolved?');">
                                        <input type="hidden" name="action" value="support_ticket_resolve">
                                        <input type="hidden" name="ticket_id" value="<?= $t['id'] ?>">
                                        <button type="submit" class="bg-blue-600/20 hover:bg-blue-600 border border-blue-500/50 hover:border-blue-500 text-blue-400 hover:text-white px-4 py-2 rounded-xl text-xs font-bold transition-all flex items-center gap-2">
                                            <i data-feather="check" class="w-3.5 h-3.5"></i> Mark Done
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <div class="text-xs text-slate-500 font-bold mb-1">Closed At</div>
                                    <div class="text-[11px] text-slate-600 font-mono"><?= date('M d, H:i', strtotime($t['resolved_at'])) ?></div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<?php require_once 'includes/footer.php'; ?>
