<?php
// Prevents direct access
if (!isset($_SESSION['owner_logged_in'])) {
    header("Location: ../index.php");
    exit();
}

$current_page = basename($_SERVER['PHP_SELF']);

$menu_items = [
    ['url' => 'dashboard.php', 'icon' => 'home', 'label' => 'Dashboard'],
    ['url' => 'users.php', 'icon' => 'users', 'label' => 'Players Management'],
    ['url' => 'globe.php', 'icon' => 'globe', 'label' => 'Player Deep-Dive'],
    ['url' => 'finance.php', 'icon' => 'dollar-sign', 'label' => 'Finance & Cashier'],
    ['url' => 'salary.php', 'icon' => 'briefcase', 'label' => 'Salary Pro (Payouts)'],
    ['url' => 'agent_payouts.php', 'icon' => 'pie-chart', 'label' => 'Agent Commissions'],
    ['url' => 'wingo.php', 'icon' => 'play-circle', 'label' => 'Wingo Control'],
    ['url' => 'fielding.php', 'icon' => 'crosshair', 'label' => 'Fielding Setup'],
    ['url' => 'support.php', 'icon' => 'headphones', 'label' => 'Support Tickets'],
    ['url' => 'codes.php', 'icon' => 'gift', 'label' => 'Gift Codes'],
    ['url' => 'demos.php', 'icon' => 'cpu', 'label' => 'Demos & Security'],
    ['url' => 'settings.php', 'icon' => 'settings', 'label' => 'Global Settings'],
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master Portal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #0f172a; color: #f8fafc; }
        /* Custom scrollbar for a cleaner look */
        ::-webkit-scrollbar { width: 6px; height: 6px; }
        ::-webkit-scrollbar-track { background: #0f172a; }
        ::-webkit-scrollbar-thumb { background: #334155; border-radius: 10px; }
        ::-webkit-scrollbar-thumb:hover { background: #475569; }
    </style>
</head>
<body class="flex h-screen overflow-hidden">

    <!-- Mobile Header -->
    <div class="lg:hidden fixed top-0 w-full bg-slate-900 border-b border-slate-800 z-50 px-4 h-16 flex items-center justify-between">
        <div class="flex items-center gap-2">
            <div class="w-8 h-8 bg-blue-600 rounded flex items-center justify-center">
                <i data-feather="monitor" class="w-4 h-4 text-white"></i>
            </div>
            <span class="font-bold tracking-tight">Master</span>
        </div>
        <button id="mobile-menu-btn" class="p-2 text-slate-400 hover:text-white">
            <i data-feather="menu"></i>
        </button>
    </div>

    <!-- Sidebar Navigation -->
    <nav id="sidebar" class="fixed inset-y-0 left-0 w-64 bg-slate-900 border-r border-slate-800 transform -translate-x-full lg:translate-x-0 transition-transform duration-200 ease-in-out z-40 flex flex-col pt-16 lg:pt-0 pb-4">
        
        <!-- Desktop Logo area -->
        <div class="hidden lg:flex px-6 h-20 items-center border-b border-slate-800 shrink-0">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-gradient-to-br from-blue-600 to-indigo-600 rounded-xl flex items-center justify-center shadow-lg shadow-blue-900/20">
                    <i data-feather="monitor" class="w-5 h-5 text-white"></i>
                </div>
                <div>
                    <h2 class="text-sm font-bold tracking-wider text-slate-100 uppercase">Master</h2>
                    <p class="text-[10px] uppercase tracking-widest text-blue-400 font-bold">Portal</p>
                </div>
            </div>
        </div>

        <div class="flex-1 overflow-y-auto px-4 py-6 space-y-1">
            <div class="text-[10px] font-bold text-slate-500 uppercase tracking-widest mb-4 px-2">Main Menu</div>
            
            <?php foreach ($menu_items as $item): ?>
                <?php 
                    $isActive = $current_page === $item['url']; 
                    $baseClass = "flex items-center gap-3 px-3 py-2.5 rounded-xl transition-all duration-200 group text-sm font-medium ";
                    $activeClass = $isActive ? "bg-blue-600/10 text-blue-400" : "text-slate-400 hover:bg-slate-800 hover:text-slate-200";
                ?>
                <a href="<?= $item['url'] ?>" class="<?= $baseClass . $activeClass ?>">
                    <i data-feather="<?= $item['icon'] ?>" class="w-4 h-4 <?= $isActive ? 'text-blue-500' : 'text-slate-500 group-hover:text-slate-400' ?>"></i>
                    <?= $item['label'] ?>
                </a>
            <?php endforeach; ?>
        </div>

        <div class="px-4 mt-auto border-t border-slate-800 pt-4 shrink-0">
            <div class="bg-slate-800/50 rounded-xl p-4 mb-4 border border-slate-700/50">
                <div class="flex items-center gap-3">
                    <div class="w-8 h-8 rounded-full bg-slate-700 flex items-center justify-center shrink-0">
                        <i data-feather="user" class="w-4 h-4 text-slate-300"></i>
                    </div>
                    <div class="overflow-hidden">
                        <p class="text-xs font-bold text-white truncate"><?= htmlspecialchars($_SESSION['owner_username'] ?? 'Admin') ?></p>
                        <p class="text-[10px] text-green-400 flex items-center gap-1"><span class="w-1.5 h-1.5 rounded-full bg-green-500 inline-block"></span> Online</p>
                    </div>
                </div>
            </div>
            <a href="logout.php" class="flex items-center gap-2 justify-center w-full px-4 py-2.5 text-red-400 hover:text-white hover:bg-red-500/20 bg-red-500/10 rounded-xl transition-colors text-sm font-bold border border-red-500/10">
                <i data-feather="log-out" class="w-4 h-4"></i> Logout
            </a>
        </div>
    </nav>

    <!-- Main Content Wrapper -->
    <main class="flex-1 flex flex-col min-w-0 overflow-hidden bg-slate-950 lg:ml-64 pt-16 lg:pt-0">
        
        <!-- Mobile Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-slate-900/80 backdrop-blur-sm z-30 hidden lg:hidden"></div>

        <div class="flex-1 overflow-y-auto w-full p-4 lg:p-8">
