<?php
require_once 'includes/auth.php';

// Fetch Dashboard Metrics
$totalUsers = $db->query("SELECT COUNT(*) FROM users")->fetchColumn();
$totalBal = $db->query("SELECT SUM(balance) FROM users WHERE COALESCE(is_demo, 0) = 0")->fetchColumn();
$pendingWD = $db->query("SELECT COUNT(*) FROM transactions WHERE type='withdrawal' AND status='pending'")->fetchColumn();
$todayDeps = $db->query("SELECT SUM(amount) FROM transactions WHERE type='deposit' AND status='completed' AND DATE(created_at) = CURDATE()")->fetchColumn();

// Fetch Recent Deposits
$recentDeposits = $db->query("SELECT t.*, u.phone FROM transactions t LEFT JOIN users u ON t.user_id = u.user_id COLLATE utf8mb4_general_ci WHERE t.type='deposit' AND t.status='completed' ORDER BY t.updated_at DESC LIMIT 10")->fetchAll();

// Fetch Recent Bets
$recentBets = $db->query("SELECT b.*, u.phone FROM wingo_bets b LEFT JOIN users u ON b.user_id = u.user_id COLLATE utf8mb4_general_ci ORDER BY b.created_at DESC LIMIT 15")->fetchAll();

require_once 'includes/header.php';
?>

<div class="mb-8">
    <h1 class="text-2xl font-bold text-white tracking-tight">System Overview</h1>
    <p class="text-sm text-slate-400 mt-1">Real-time statistics and recent activity monitor.</p>
</div>

<!-- Key Metrics Grid -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    
    <!-- Total Users -->
    <div class="bg-slate-800/50 backdrop-blur-sm border border-slate-700/50 rounded-2xl p-6 shadow-lg shadow-slate-900/50 flex flex-col relative overflow-hidden group">
        <div class="absolute -right-6 -top-6 w-24 h-24 bg-blue-500/10 rounded-full blur-2xl group-hover:bg-blue-500/20 transition-all"></div>
        <div class="flex items-center gap-3 mb-4">
            <div class="w-10 h-10 rounded-xl bg-blue-500/10 flex items-center justify-center border border-blue-500/20">
                <i data-feather="users" class="w-5 h-5 text-blue-400"></i>
            </div>
            <h3 class="text-slate-400 text-sm font-semibold uppercase tracking-wider">Total Users</h3>
        </div>
        <div class="text-3xl font-black text-white tracking-tight"><?= number_format($totalUsers) ?></div>
    </div>

    <!-- User Balances -->
    <div class="bg-slate-800/50 backdrop-blur-sm border border-slate-700/50 rounded-2xl p-6 shadow-lg shadow-slate-900/50 flex flex-col relative overflow-hidden group">
         <div class="absolute -right-6 -top-6 w-24 h-24 bg-green-500/10 rounded-full blur-2xl group-hover:bg-green-500/20 transition-all"></div>
        <div class="flex items-center gap-3 mb-4">
            <div class="w-10 h-10 rounded-xl bg-green-500/10 flex items-center justify-center border border-green-500/20">
                <i data-feather="dollar-sign" class="w-5 h-5 text-green-400"></i>
            </div>
            <h3 class="text-slate-400 text-sm font-semibold uppercase tracking-wider">User Balances</h3>
        </div>
        <div class="text-3xl font-black text-white tracking-tight">₹<?= money($totalBal) ?></div>
    </div>

    <!-- Pending Withdrawals -->
    <div class="bg-slate-800/50 backdrop-blur-sm border border-slate-700/50 rounded-2xl p-6 shadow-lg shadow-slate-900/50 flex flex-col relative overflow-hidden group">
         <div class="absolute -right-6 -top-6 w-24 h-24 bg-red-500/10 rounded-full blur-2xl group-hover:bg-red-500/20 transition-all"></div>
        <div class="flex items-center justify-between mb-4">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-xl bg-red-500/10 flex items-center justify-center border border-red-500/20">
                    <i data-feather="clock" class="w-5 h-5 text-red-400"></i>
                </div>
                <h3 class="text-slate-400 text-sm font-semibold uppercase tracking-wider">Pending W/D</h3>
            </div>
            <?php if($pendingWD > 0): ?>
                <span class="flex h-3 w-3 relative">
                  <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-red-400 opacity-75"></span>
                  <span class="relative inline-flex rounded-full h-3 w-3 bg-red-500"></span>
                </span>
            <?php endif; ?>
        </div>
        <div class="text-3xl font-black text-red-400 tracking-tight"><?= $pendingWD ?> <span class="text-sm font-medium text-slate-500 ml-1">requests</span></div>
    </div>

    <!-- Deposits Today -->
    <div class="bg-slate-800/50 backdrop-blur-sm border border-slate-700/50 rounded-2xl p-6 shadow-lg shadow-slate-900/50 flex flex-col relative overflow-hidden group">
         <div class="absolute -right-6 -top-6 w-24 h-24 bg-purple-500/10 rounded-full blur-2xl group-hover:bg-purple-500/20 transition-all"></div>
        <div class="flex items-center gap-3 mb-4">
            <div class="w-10 h-10 rounded-xl bg-purple-500/10 flex items-center justify-center border border-purple-500/20">
                <i data-feather="trending-up" class="w-5 h-5 text-purple-400"></i>
            </div>
            <h3 class="text-slate-400 text-sm font-semibold uppercase tracking-wider">Deposits Today</h3>
        </div>
        <div class="text-3xl font-black text-purple-400 tracking-tight">₹<?= money($todayDeps) ?></div>
    </div>

</div>

<!-- Recent Activity Tables -->
<div class="grid grid-cols-1 xl:grid-cols-3 gap-6">

    <!-- Recent Deposits Table -->
    <div class="bg-slate-800/50 backdrop-blur-sm border border-slate-700/50 rounded-2xl p-6 shadow-lg shadow-slate-900/50 xl:col-span-1">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold text-white flex items-center gap-2">
                <i data-feather="arrow-down-circle" class="w-5 h-5 text-green-400"></i> Recent Deposits
            </h3>
            <a href="finance.php" class="text-xs font-bold text-blue-400 hover:text-blue-300 transition-colors uppercase tracking-wider bg-blue-500/10 px-3 py-1.5 rounded-lg border border-blue-500/20 flex items-center gap-1">View All <i data-feather="chevron-right" class="w-3 h-3"></i></a>
        </div>

        <?php if(empty($recentDeposits)): ?>
            <div class="text-center py-8 bg-slate-900/50 rounded-xl border border-slate-800 border-dashed">
                <i data-feather="inbox" class="w-8 h-8 text-slate-600 mx-auto mb-2"></i>
                <p class="text-sm text-slate-500 font-medium">No recent deposits.</p>
            </div>
        <?php else: ?>
            <div class="space-y-3">
                <?php foreach($recentDeposits as $d): ?>
                    <div class="group flex items-center justify-between p-3 rounded-xl bg-slate-900/50 border border-slate-800 hover:border-slate-700 transition-all">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-full bg-slate-800 flex items-center justify-center shrink-0">
                                <i data-feather="user" class="w-4 h-4 text-slate-400"></i>
                            </div>
                            <div>
                                <p class="text-sm font-bold text-slate-200"><?= h($d['user_id']) ?></p>
                                <p class="text-xs text-slate-500"><?= h($d['phone']) ?></p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-sm font-black text-green-400">+₹<?= money($d['amount']) ?></p>
                            <p class="text-[10px] text-slate-500 font-medium uppercase tracking-wider flex items-center gap-1 justify-end"><i data-feather="clock" class="w-3 h-3"></i> <?= date('H:i', strtotime($d['updated_at'])) ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Live Wingo Bets Table -->
    <div class="bg-slate-800/50 backdrop-blur-sm border border-slate-700/50 rounded-2xl p-6 shadow-lg shadow-slate-900/50 xl:col-span-2">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold text-white flex items-center gap-2">
                <i data-feather="activity" class="w-5 h-5 text-blue-400"></i> Live Game Activity <span class="text-xs text-white/50 font-normal bg-blue-600/20 px-2 py-0.5 rounded-md ml-2 border border-blue-500/20">Wingo</span>
            </h3>
            <a href="wingo.php" class="text-xs font-bold text-blue-400 hover:text-blue-300 transition-colors uppercase tracking-wider bg-blue-500/10 px-3 py-1.5 rounded-lg border border-blue-500/20 flex items-center gap-1">Control Panel <i data-feather="chevron-right" class="w-3 h-3"></i></a>
        </div>

        <?php if(empty($recentBets)): ?>
            <div class="text-center py-12 bg-slate-900/50 rounded-xl border border-slate-800 border-dashed">
                <i data-feather="radio" class="w-8 h-8 text-slate-600 mx-auto mb-2 animate-pulse"></i>
                <p class="text-sm text-slate-500 font-medium">Waiting for live bets...</p>
            </div>
        <?php else: ?>
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="border-b border-slate-700">
                            <th class="pb-3 px-2 text-[10px] font-bold text-slate-500 uppercase tracking-widest">Player</th>
                            <th class="pb-3 px-2 text-[10px] font-bold text-slate-500 uppercase tracking-widest">Selection</th>
                            <th class="pb-3 px-2 text-[10px] font-bold text-slate-500 uppercase tracking-widest">Stake</th>
                            <th class="pb-3 px-2 text-[10px] font-bold text-slate-500 uppercase tracking-widest right-align">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-800/50">
                        <?php foreach($recentBets as $b): 
                            $val = $b['bet_value'];
                            $badgeStyle = "bg-slate-800 text-slate-300 border-slate-700";
                            if ($val === 'green') $badgeStyle = "bg-green-500/10 text-green-400 border-green-500/20";
                            elseif ($val === 'red') $badgeStyle = "bg-red-500/10 text-red-400 border-red-500/20";
                            elseif ($val === 'violet') $badgeStyle = "bg-violet-500/10 text-violet-400 border-violet-500/20";
                            elseif ($val === 'big') $badgeStyle = "bg-yellow-500/10 text-yellow-500 border-yellow-500/20 text-yellow-600";
                            elseif ($val === 'small') $badgeStyle = "bg-blue-500/10 text-blue-400 border-blue-500/20";
                        ?>
                        <tr class="hover:bg-slate-800/30 transition-colors group">
                            <td class="py-3 px-2 whitespace-nowrap">
                                <div class="font-bold text-sm text-slate-200"><?= h($b['user_id']) ?></div>
                                <div class="text-[10px] text-slate-500"><?= h($b['phone']) ?></div>
                            </td>
                            <td class="py-3 px-2">
                                <span class="text-xs font-bold uppercase tracking-wider px-2.5 py-1 rounded-md border <?= $badgeStyle ?>">
                                    <?= h($val) ?>
                                </span>
                            </td>
                            <td class="py-3 px-2 whitespace-nowrap">
                                <span class="font-bold text-slate-300">₹<?= money($b['amount']) ?></span>
                            </td>
                            <td class="py-3 px-2 text-right">
                                <?php if($b['status']==='pending'): ?>
                                    <span class="inline-flex items-center gap-1.5 text-xs font-medium text-yellow-500 bg-yellow-500/10 px-2 py-1 rounded-md border border-yellow-500/20">
                                        <i data-feather="loader" class="w-3 h-3 animate-spin"></i> Pending
                                    </span>
                                <?php elseif($b['status']==='win'): ?>
                                    <div class="flex flex-col items-end">
                                        <span class="inline-flex text-xs font-bold text-green-400">+₹<?= money($b['win_amount']) ?></span>
                                        <span class="text-[10px] text-slate-500">Won</span>
                                    </div>
                                <?php else: ?>
                                    <span class="text-xs font-medium text-slate-500">Lost</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

</div>

<?php require_once 'includes/footer.php'; ?>
